/*
 * Decompiled with CFR 0.152.
 */
package mlsoft.mct;

import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class MlIconMaker {
    protected int _curRow = 0;
    protected int _width = 0;
    protected int _height = 0;
    protected int[] _colMap = new int[256];
    protected int[] _pixels = null;

    public MlIconMaker() {
        this._colMap[32] = 0;
        this._colMap[87] = -1;
        this._colMap[75] = -16777216;
        this._colMap[82] = -65536;
        this._colMap[71] = -16711936;
        this._colMap[66] = -16776961;
    }

    public synchronized void clear() {
        if (this._width != 0 && this._height != 0) {
            this._pixels = new int[this._width * this._height];
        }
        this._curRow = 0;
    }

    public synchronized Image createImage(Component component) {
        if (this._pixels == null) {
            return null;
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(this._width, this._height, this._pixels, 0, this._width);
        return component.createImage(memoryImageSource);
    }

    public synchronized void setColor(char c, Color color) {
        if (c >= '\u0100') {
            return;
        }
        this._colMap[c] = color.getRGB() & 0xFF000000;
    }

    public synchronized void setColor(char c, int n) {
        if (c >= '\u0100') {
            return;
        }
        this._colMap[c] = n;
    }

    public synchronized void setDimensions(int n, int n2) {
        if (n == this._width && n2 == this._height) {
            return;
        }
        this._width = n;
        this._height = n2;
        if (n == 0 && n2 == 0) {
            this._pixels = null;
            return;
        }
        this._pixels = new int[n * n2];
    }

    public synchronized void setPixels(String string) {
        this.setPixels(this._curRow++, string);
    }

    public synchronized void setPixels(int n, String string) {
        if (string.length() != this._width) {
            return;
        }
        int n2 = n * this._width;
        int n3 = 0;
        while (n3 < this._width) {
            this._pixels[n3 + n2] = this._colMap[string.charAt(n3)];
            ++n3;
        }
    }
}

